* This data set merges all of the relavant fiels and defines the key variables
cd "\\micro.intra\Projekt\P0624$\P0624_Gem\Data Extraction and Files\Data files"

*Start with the main panel data for the policians
use pol_panel, clear
 duplicates drop p_id year, force

drop if year>=2013 
drop partner_id

*merge with the main panel with partner data.
joinby p_id year using partner_panel, unmatched(both) 
drop _merge
fillin year p_id
*merge with the file on policitians childreb
joinby p_id year using "child_pol_year", unmatched(master)
drop _merge
*merge with the file on policitians children
joinby partner_id year using "child_polpartner_year", unmatched(master)
drop _merge

*add data on joint children of currently married couples.
joinby p_id year using "\\micro.intra\Projekt\P0624$\P0624_Gem\Data Extraction and Files\Data files\joint_child_birthyear", unmatched(master) _merge(_merge)
drop _merge

*define birth year of firstborn joint child
egen fodar_first= rowmin ( fodar_jc_1_id-fodar_jc_12_id)
duplicates drop p_id year, force

**add panel for each potential partner that a politician in the sampel has had. In
*estimation sample no one has had more than three partnes at time of the promotion
*This is why we only add information for three partners per idnividual
joinby p_id year using partner_panel_wide, unmatched(master) 
drop _merge

*merge with id's for estimation sample, this restrics the sample to the relevant observations
joinby p_id  using est_samp_id, unmatched(none) 

**add data on children of each of the three partners
joinby partner_id1 year using "child_polpartner_year_wide1", unmatched(master)
drop _merge
joinby partner_id2 year using "child_polpartner_year_wide2", unmatched(master)
drop _merge

joinby partner_id3 year using "child_polpartner_year_wide3", unmatched(master)
drop _merge

**To allow us to look at parnetal leave before matching we add data for
*couples parental leave for their joint children before getting married,
*this is what the code below does
gen partner_alt=partner_id
sort p_id year
replace partner_alt=partner_id[_n+1] if partner_id==.

replace parentalpay=parnetalpay if year<1990

ren child_0_3_d_par child_0_3_d_p
foreach var in lab_inc_p  parentalpay_p child_0_3_d_p{
	gen `var'_alt=`var'
	forvalues n=1/3{
		replace  `var'_alt = `var'`n' if  `var'_alt==. &  partner_alt ==partner_id`n' & gift_p`n'!=1
	}
}

*creates couple id, the parental leave division, either based on pay
*or days of leave is then caldulated for each couple

egen couple_id= group(p_id partner_id) if  partner_id!=.
egen couple_id_alt= group(p_id partner_alt) if  partner_alt!=.

gen parentaldays_03_p= parentaldays_temp_p + parentaldays_p	if  child_0_3_d==1 & child_0_3_d_p==1 &  partner_id!=.
gen parentaldays_03= parentaldays_temp + parentaldays	if  child_0_3_d==1 & child_0_3_d_p==1  & partner_id!=.

gen pp_incshare=parentalpay/lab_inc if child_0_3_d==1 & child_0_3_d_p_alt==1 
gen pp_incshare_p=parentalpay_p_alt/lab_inc_p_alt if child_0_3_d==1 & child_0_3_d_p_alt==1 

bysort partner_id couple_id:egen parentaldays_03_sum_p= sum(parentaldays_03_p)
bysort p_id couple_id:egen parentaldays_03_sum= sum(parentaldays_03)

gen parentaldays_rel_co_b= parentaldays_03_sum/(parentaldays_03_sum+parentaldays_03_sum_p)

bysort p_id couple_id: egen parentaldays_rel_co= max (parentaldays_rel_co_b)

bysort p_id: egen parentaldays_rel_ind= mean (parentaldays_rel_co_b)


bysort partner_alt couple_id_alt:egen pp_incshare_sum_p= sum(pp_incshare_p)
bysort p_id couple_id_alt:egen pp_incshare_sum= sum(pp_incshare)


bysort p_id couple_id_alt: egen  ppshare_rel_co= max (ppshare_rel_co_b)


gen divorce= civil=="S" |civil=="S " if civil!=""

replace gift =1 if year==2013| year==2014

*Define variables for being married and divorces

gen married= partner_id!=. & gift==1
gen married_pre_b= married if year==2012
bysort p_id :egen married_pre=max(married_pre_b)
gen div_pre_b= divorce if year==2012
bysort p_id :egen div_pre=max(div_pre_b)
replace divorce =0 if (year==2013|year==2014)
replace divorce =1 if married==0 & (div_pre==1|married_pre==1) & (year==2013|year==2014)
drop div_pre*
gen div_post_b= divorce if year==1990
bysort p_id :egen div_post=max(div_post_b)

gen married_p90= partner_id!=. if year<1990
replace married =married_p90 if year<1990
bysort p_id :egen m_90max=max(married_p90)

drop married_p90
drop married_pre*
sort p_id year
gen married_pre=0
forvalues n=1/13{
replace married_pre= 1 if  married[_n-`n']  & (year-`n')==year[_n-`n'] & p_id==p_id[_n-`n']
}
replace divorce=0 if year<1990
replace divorce =1 if year<1990 & married==0 & married_pre==1

replace divorce =1 if year<1990 & m_90max!=1 & div_post==1

*define variable for einfng married or having a partner

gen mar_par= partner_id!=. 
  
gen partner= mar_par if year>=1990 & year<=2013
gen partner_id_m= partner_id if gift==1

*calculate year of marriage and marrigae length
bysort p_id couple_id: egen mar_year= min(year) if married==1
replace mar_year =fodar_first if mar_year==1979 & fodar_first<1979
gen length_mar= year-mar_year
replace wage_inc_p = w_inc_p if year<1990 & w_inc_p>=0
gen mar_length= year-mar_year

*define variable for second marriage
sort p_id year
gen sec_mar=0 if married==1
forvalues n=1(1)20{
replace sec_mar= 1 if  partner_id_m!= partner_id_m[_n-`n'] & partner_id_m[_n-`n']!=. & (year-`n')==year[_n-`n'] & p_id==p_id[_n-`n']
}

 *****define variable for election period
gen  electionperiod=1982     if year==1983 |year==1984 |year==1985
replace electionperiod=1985 if year==1986 |year==1987 |year==1988
replace electionperiod=1988 if year==1989 |year==1990 |year==1991
replace electionperiod=1991 if year==1992 |year==1993 |year==1994
replace electionperiod=1994 if year==1995 |year==1996 |year==1997|year==1998
replace electionperiod=1998 if year==1999 |year==2000 |year==2001 |year==2002
replace electionperiod=2002 if year==2003 |year==2004 |year==2005 |year==2006
replace electionperiod=2006 if year==2007 |year==2008 |year==2009 |year==2010
replace electionperiod=2010 if year==2011 |year==2012 |year==2013 |year==2014 

*define age and gender variables. 
gen age= year-FodelseAr
gen age_p= year-FodelseAr_p
gen woman_p =Kon_p==2
gen age_mar= mar_year-FodelseAr


*define incomes as real rather than nominal incomes
foreach var in  wage_inc_p wage_inc wage_inc_p1 wage_inc_p2 wage_inc_p3  {
replace `var'= `var'/100 if year<1990
gen `var'_real= .
replace `var'_real= `var'/0.3376 if year==1979
replace `var'_real= `var'/0.3836 if year==1980
replace `var'_real= `var'/0.43 if year==1981
replace `var'_real= `var'/0.4668 if year==1982
replace `var'_real= `var'/0.5085 if year==1983
replace `var'_real= `var'/0.5492 if year==1984
replace `var'_real= `var'/0.5897 if year==1985
replace `var'_real= `var'/0.6146 if year==1986
replace `var'_real= `var'/0.6406 if year==1987
replace `var'_real= `var'/0.6779 if year==1988
replace `var'_real= `var'/0.7214 if year==1989
replace `var'_real= `var'/0.795905 if year==1990
replace `var'_real= `var'/0.8715 if year==1991
replace `var'_real= `var'/0.891446 if year==1992
replace `var'_real= `var'/0.932873 if year==1993
replace `var'_real= `var'/0.953203 if year==1994
replace `var'_real= `var'/0.977369 if year==1995
replace `var'_real= `var'/0.981972 if year==1996
replace `var'_real= `var'/0.986958 if year==1997
replace `var'_real= `var'/0.985807 if year==1998
replace `var'_real= `var'/0.990027 if year==1999
replace `var'_real= `var'/1 if year==2000
replace `var'_real= `var'/1.024549 if year==2001
replace `var'_real= `var'/1.046414 if year==2002
replace `var'_real= `var'/1.066743 if year==2003
replace `var'_real= `var'/1.070963 if year==2004
replace `var'_real= `var'/1.075566 if year==2005
replace `var'_real= `var'/1.090219 if year==2006
replace `var'_real= `var'/1.114346 if year==2007
replace `var'_real= `var'/1.153088 if year==2008
replace `var'_real= `var'/1.149444 if year==2009
replace `var'_real= `var'/1.1641 if year==2010
replace `var'_real= `var'/1.1945 if year==2011
replace `var'_real= `var'/1.205 if year==2012
}

*define variable for years since last election
 gen per_year = year-electionperiod

*add data on birth region for both policians and partner
		joinby partner_id using "\\micro.intra\Projekt\P0624$\P0624_Gem\Promotions and divorce\partner pol inv.dta", unmatched(master)
		drop _merge
		joinby p_id using "\\micro.intra\Projekt\P0624$\P0624_Gem\Data Extraction and Files\Data files\Birth_region.dta" , unmatched(master)
		gen same_eth=FodelseVarldsdel_p==FodelseVarldsdel if FodelseVarldsdel_p!=""
	
	


	destring Kon Kon_p Sun2000niva Sun2000niva_p deathyear_p deathyear, replace force
*define uears of education for partner
gen educ_year_p=.
replace educ_year_p= 7.5 if Sun2000niva_p>=100 & Sun2000niva_p<200
replace educ_year_p= 9.4 if Sun2000niva_p>=200 & Sun2000niva_p<300
replace educ_year_p= 11.2 if Sun2000niva_p>=300 & Sun2000niva_p<330
replace educ_year_p= 12.4 if Sun2000niva_p>=330 & Sun2000niva_p<400
replace educ_year_p= 14.2 if Sun2000niva_p>=410& Sun2000niva_p<530
replace educ_year_p= 17 if Sun2000niva_p>=530 & Sun2000niva_p<600
replace educ_year_p= 20.4 if Sun2000niva_p>=600 & Sun2000niva_p<998

*create dummy for having tertiary education 
gen ter_ed=educ_year>14 if educ_year!=.
gen ter_ed_p=educ_year_p>14 if educ_year_p!=.

*Create dummies for being married, having a partner, and being diviorced,
*in each of the seven years leading up to an election, and in each of
*the ten years after the election
	sort p_id year
forvalues n=1/7{
local y=-`n'-1
gen par_n`n'=  partner_id[_n+`y']!=. if   p_id==p_id[_n+`y'] & per_year==1 
gen mar_n`n'=  partner_id_m[_n+`y']!=. if   p_id==p_id[_n+`y'] & per_year==1 
gen div_n`n'= divorce[_n+`y'] if   p_id==p_id[_n+`y'] & per_year==1 
}


forvalues n=0/10{
local y=`n'-1
gen par_`n'=  partner_id[_n+`y']!=. if   p_id==p_id[_n+`y'] & per_year==1
gen mar_`n'=  partner_id_m[_n+`y']!=. if   p_id==p_id[_n+`y'] & per_year==1
gen div_`n'= divorce[_n+`y'] if   p_id==p_id[_n+`y'] & per_year==1
}


*This creates the main outcome variable as well as outcome variables for having different 
*starting years. It defines dummies for remaining amrried to the person you were married
*between 7 and 1 year before prior to the election
forvalues n=0/10{
local y=`n'-1
gen rem_mar1_`n'= partner_id_m[_n-1]== partner_id_m[_n+`y'] if  partner_id_m[_n-1]!=.  & p_id==p_id[_n+`y'] & per_year==1 &  deathyear_p>year[_n+`y']
}


forvalues v=2/7{
sort p_id year
local x=`v'-1

forvalues n=1/`x'{
local y=-`n'-1
gen rem_mar`v'_n`n'= partner_id_m[_n-`v']== partner_id_m[_n+`y'] if  partner_id_m[_n-`v']!=. & p_id==p_id[_n+`y'] & per_year==1 &  deathyear_p>year[_n+`y']
}

forvalues n=0/10{
local y=`n'-1
gen rem_mar`v'_`n'= partner_id_m[_n-`v']== partner_id_m[_n+`y'] if  partner_id_m[_n-`v']!=.  & p_id==p_id[_n+`y'] & per_year==1 &  deathyear_p>year[_n+`y']
}
}

*this cretes vakues for the variables below in each of the 7 years leading up to 
*the election and each of the ten years after the election
foreach var in wage_inc_real  ppshare_rel_co gift parentaldays age mar_length{
sort p_id year
forvalues n=1/7{
local y=-`n'-1
gen `var'_n`n'=  `var'[_n+`y'] if   p_id==p_id[_n+`y'] & per_year==1 &  deathyear_p>year[_n+`y']
}

forvalues n=0/10{
local y=`n'-1
gen `var'_`n'=  `var'[_n+`y'] if   p_id==p_id[_n+`y'] & per_year==1 &  deathyear_p>year[_n+`y']
}
}

*This creats a variable for the income in the years after the election
* for the spouse of the politiicans
* (in the election year) irrespective of if they continued to be married or not


foreach var in  wage_inc {
	sort p_id year
	forvalues n=1/4{
		local y=-`n'-1
		gen `var'_real_pmo_n`n'= `var'_p1_real[_n+`y'] if partner_id_m[_n-1]== partner_id1[_n-1] & partner_id_m[_n-1]!=. & p_id==p_id[_n+`y'] & per_year==1 &  deathyear_p>year[_n+`y']
	}

	forvalues n=0/10{
		local y=`n'-1
		gen `var'_real_pmo_`n'= `var'_p1_real[_n+`y'] if partner_id_m[_n-1]== partner_id1[_n-1] &  partner_id_m[_n-1]!=. & p_id==p_id[_n+`y'] & per_year==1 &  deathyear_p>year[_n+`y']

		}
	

	forvalues mar=2/3{
	sort p_id year
	forvalues n=1/4{
		local y=-`n'-1
		replace `var'_real_pmo_n`n'= `var'_p`mar'_real[_n+`y'] if partner_id_m[_n-1]== partner_id`mar'[_n-1]&  partner_id_m[_n-1]!=. & p_id==p_id[_n+`y'] & per_year==1 &  deathyear_p>year[_n+`y']
	}

	forvalues n=0/8{
		local y=`n'-1
		replace `var'_real_pmo_`n'= `var'_p`mar'_real[_n+`y'] if partner_id_m[_n-1]== partner_id`mar'[_n-1] & partner_id_m[_n-1]!=. & p_id==p_id[_n+`y'] & per_year==1 &  deathyear_p>year[_n+`y']

		}
	}
}

gen parentaldays_sum_p3= parentaldays_temp_p3+  parentaldays_p3
gen agep_p1=year-FodelseAr_p1
gen agep_p2=year-FodelseAr_p2
gen agep_p3=year-FodelseAr_p3



*This creats a variable for the age in the years before or after the election 
*of the spouse of the politican's 4 years prior to the election
* , irrespective of if they continued to be married or not
foreach var in   agep {
	sort p_id year
	forvalues n=1/4{
		local y=-`n'-1
		gen `var'_p_n`n'= `var'_p1[_n+`y'] if partner_id_m[_n-5]== partner_id1[_n-5] & partner_id_m[_n-5]!=. & p_id==p_id[_n+`y'] & per_year==1 &  deathyear_p>year[_n+`y']
	}

	forvalues n=0/8{
		local y=`n'-1
		gen `var'_p_`n'= `var'_p1[_n+`y'] if partner_id_m[_n-5]== partner_id1[_n-5] &  partner_id_m[_n-5]!=. & p_id==p_id[_n+`y'] & per_year==1 &  deathyear_p>year[_n+`y']

		}
	forvalues mar=2/3{
	sort p_id year
	forvalues n=1/4{
		local y=-`n'-1
		replace `var'_p_n`n'= `var'_p`mar'[_n+`y'] if partner_id_m[_n-5]== partner_id`mar'[_n-5]&  partner_id_m[_n-5]!=. & p_id==p_id[_n+`y'] & per_year==1 &  deathyear_p>year[_n+`y']
	}

	forvalues n=0/8{
		local y=`n'-1
		replace `var'_p_`n'= `var'_p`mar'[_n+`y'] if partner_id_m[_n-5]== partner_id`mar'[_n-5] & partner_id_m[_n-5]!=. & p_id==p_id[_n+`y'] & per_year==1 &  deathyear_p>year[_n+`y']

		}
	}
}
*This creats a variable for the income in the years before or after the election 
*of the spouse of the politican's 4 years prior to the election
* , irrespective of if they continued to be married or not
foreach var in wage_inc {
	sort p_id year
	forvalues n=1/4{
		local y=-`n'-1
		gen `var'_real_p_n`n'= `var'_p1_real[_n+`y'] if partner_id_m[_n-5]== partner_id1[_n-5] & partner_id_m[_n-5]!=. & p_id==p_id[_n+`y'] & per_year==1 &  deathyear_p>year[_n+`y']
	}

	forvalues n=0/10{
		local y=`n'-1
		gen `var'_real_p_`n'= `var'_p1_real[_n+`y'] if partner_id_m[_n-5]== partner_id1[_n-5] &  partner_id_m[_n-5]!=. & p_id==p_id[_n+`y'] & per_year==1 &  deathyear_p>year[_n+`y']

		}

	forvalues mar=2/3{
	sort p_id year
	forvalues n=1/4{
		local y=-`n'-1
		replace `var'_real_p_n`n'= `var'_p`mar'_real[_n+`y'] if partner_id_m[_n-5]== partner_id`mar'[_n-5]&  partner_id_m[_n-5]!=. & p_id==p_id[_n+`y'] & per_year==1 &  deathyear_p>year[_n+`y']
	}

	forvalues n=0/8{
		local y=`n'-1
		replace `var'_real_p_`n'= `var'_p`mar'_real[_n+`y'] if partner_id_m[_n-5]== partner_id`mar'[_n-5] & partner_id_m[_n-5]!=. & p_id==p_id[_n+`y'] & per_year==1 &  deathyear_p>year[_n+`y']

		}
	}
}

***Below we define the control variables measures in the election year and 4 years prior to the election, these are later used as control variables
	sort p_id year
gen partner_id_b=   partner_id[_n-5] if p_id==p_id[_n-5] & per_year==1 

gen wa_inc=wage_inc_real
gen wa_inc_p=wage_inc_p_real
foreach var in age_p woman_p ter_ed_p ter_ed wa_inc wa_inc_p same_eth child_0_6_d child_0_18_d  partner_id sec_mar age_mar{
gen `var'_n4=`var'[_n-5] if p_id==p_id[_n-5] & per_year==1 
gen `var'_n1=`var'[_n-2] if p_id==p_id[_n-2] & per_year==1 
gen `var'_0=`var'[_n-1] if p_id==p_id[_n-1] & per_year==1 
}
drop partner_id1- gift_p3
	drop if year==1982 |year==1985 |year==1988 |year==1991 |year==1994 |year==1998 |year==2002 |year==2006| year==2010

*Data is only kept for the for observation in the beginning of each election period, the data relevant data is den kept
keep if per_year==1 & _fillin!=1
keep   parentaldays_rel_co  ppshare_rel_co partner_id_b ter_ed disp_inc lab_inc parentalpay- sick_pay wage_inc par_n1- wage_inc_real_p_8 (max)  age_p_n4 - age_mar_0  Kon Kon_p deathyear_p deathyear  Sun2000In* civil* p_id electionperiod
duplicates drop p_id electionperiod

ren partner_id_b partner_id
gen year=electionperiod
gen valar=electionperiod

*merge with data on politicians
joinby p_id  valar using "pol_grund_2014.dta", unmatched(both) _merge(_merge)

drop _merge
joinby p_id  electionperiod using "parliamentarians.dta", unmatched(both) _merge(_merge)

replace electionperiod=valar if electionperiod==.

drop if electionperiod==.
replace year=electionperiod if year==.

replace nrinom_hl=nrinom if electionperiod<1991
drop _merge
*Add municipal level electoral data
joinby llkk valar using "kommundata.dta", unmatched(master)
drop _merge
duplicates drop p_id electionperiod , force

*Join with data on actual appointments (only available for 2006 and 2010
 joinby p_id valar using "uppdrag.dta", unmatched(master) _merge(_merge2)
	foreach var of varlist kso vice_kso ord vice {
	replace `var'= 0 if `var' ==. & valar>2005 & valar!=.
 }


gen parti_in= parti_initial

*Define dummy for party of the Mayor
gen  kso_parti=kso_p=="s" & parti_in=="S" if kso_p!="" 
replace kso_parti= 1 if kso_p=="v"  & parti_in=="V"
replace kso_parti= 1 if  kso_p=="mp"  & parti_in=="G"
replace kso_parti= 1 if kso_p=="m"  & parti_in=="M"
replace kso_parti= 1 if kso_p=="c"  & parti_in=="C"
replace kso_parti= 1 if kso_p=="kd"  & parti_in=="K"
replace kso_parti= 1 if kso_p=="fp"  & parti_in=="F"
	
* In years prior to 2010 we have external data on which pary appoints the mayor,
* starting in 2010 we have to define this based on appointments.
bysort llkk parti_in valar: egen kso_parti_max=max(kso)
replace kso_parti= kso_parti_max if valar==2010
	
* define seats share for each party. Prior to 1991 we use data 
*on the number of elected politicians from our ouwn data since we do not
*have external data on the number of seats woen
gen  seat_share = s_mandat_proc if parti_in=="S"
replace seat_share = v_mandat_proc  if  parti_in=="V"
replace seat_share = mp_mandat_proc  if   parti_in=="G"
replace seat_share = m_mandat_proc  if parti_in=="M"
replace seat_share = c_mandat_proc  if  parti_in=="C"
replace seat_share = kd_mandat_proc  if parti_in=="K"
replace seat_share = fp_mandat_proc  if parti_in=="F"
bysort llkk year: egen o_seats=sum(vald)
bysort llkk year parti_in : egen op_seats=sum(vald)
gen o_seat_share= op_seats/o_seats
replace seat_share=o_seat_share if electionperiod<1991

*Define the largest party in each of the two blocks
bysort llkk ar: egen max_ss_v= max(seat_share) if parti_in=="S" | parti_in=="V" | parti_in=="G"  & seat_share!=.
bysort llkk ar: egen max_ss_h= max(seat_share) if parti_in=="M" | parti_in=="C" | parti_in=="K" | parti_in=="F" & seat_share!=.
	
gen v_dum= parti_in=="S" | parti_in=="V" | parti_in=="G" 
gen h_dum= parti_in=="M" | parti_in=="C" | parti_in=="K" | parti_in=="F"
	
gen largest_v = seat_share ==max_ss_v if seat_share!=.
gen largest_h = seat_share ==max_ss_h if seat_share!=.

*define the leader in each party, make sure that we can indentify leader based on list rank (i.e. there are not
*two top ranked candidates (this very rarely happens since parties almost always have one unique list)
sort p_id year 
gen etta= nrinom_hl==1 if nrinom_hl!=.
gen lg_block = largest_v==1 |largest_h==1
bysort  llkk year: egen v_ettor= count(vald) if  largest_v==1  & vald==1  & nrinom_hl==1
bysort  llkk year: egen h_ettor= count(vald) if  largest_h==1  & vald==1  & nrinom_hl==1
gen un_ett_b= v_ettor==1|h_ettor==1
bysort  llkk year  parti_initial : egen un_ett= max(un_ett_b) 

*define mayor
		gen kso_app= etta==1 & kso_parti==1 & un_ett==1
		gen kso_app_alt= etta==1 & un_ett==1 & ((v_smaj==1 & largest_v==1)  | (h_smaj==1 & largest_h==1))

*When defining people that have been mayors before we take a
*less restrictive approach and restrict all potential mayors,
*i.e. include also those that where not unique top ranked politicans	
*We define someone as having held mayor ship or parliamentary seats as someone who held 
*the position in either of the last 5 election periods.	
sort p_id electionperiod
gen top_pos=  nrinom_hl==1 & kso_parti==1 
sort p_id electionperiod
gen top_pos_prev=0
forvalues n=1(1)5{
	replace top_pos_prev=1 if top_pos[_n-`n']==1 & p_id==p_id[_n-`n'] 
}

drop elec_parl_prev
sort p_id electionperiod
gen elec_parl_prev=0
forvalues n=1(1)5{
	replace elec_parl_prev=1 if (elec_parl[_n-`n']==1 ) & p_id==p_id[_n-`n'] 
}



*Define the different relevant samples, including the close election samples
	gen samp_full_kso=electionperiod>1990 &  un_ett==1  & top_pos_prev==0  & nrinom_hl==1   & age_1<64  
	gen samp_close_kso=electionperiod>1990 &  un_ett==1  & top_pos_prev==0  & nrinom_hl==1   & age_1<64 & (abs(dist_v_simp)<0.05 |  abs(dist_h_simp)<0.05)
	gen samp_parl = (mar_win==1 |mar_los==1) &elec_parl_prev==0 & age_1<64 
	gen samp_maj_kso=electionperiod>1990 &  un_ett==1  & top_pos_prev==0  & nrinom_hl==1   & age_1<64  &(v_smaj==1 |h_smaj==1)
	gen est_samp= samp_full_kso==1|samp_parl ==1


foreach num in ds1 ds2 ds25  ds3 ds35 ds4 {
	gen samp_parl_`num' =(mar_win_`num'==1 |mar_los_`num'==1) & elec_parl_prev==0  & age_1<64  
}
gen close_1= (samp_full_kso==1 &  (abs(dist_v_simp)<0.03 | abs(dist_h_simp)<0.03) )| (samp_parl_ds4==1)  
gen close_2= (samp_full_kso==1 &  (abs(dist_v_simp)<0.04 | abs(dist_h_simp)<0.04) )| (samp_parl_ds35==1)  
gen close_4= (samp_full_kso==1 &  (abs(dist_v_simp)<0.06 | abs(dist_h_simp)<0.06) )| (samp_parl_ds25==1)  
gen close_5= (samp_full_kso==1 &  (abs(dist_v_simp)<0.7 |  abs(dist_h_simp)<0.07) )| (samp_parl_ds2==1)  
gen main=(samp_full_kso==1 | samp_parl==1)   
gen main_maj=(samp_maj_kso==1 | samp_parl==1)
gen main_div=(samp_full_kso==1 | samp_parl==1) & rem_mar1_3==0  
gen close= (samp_close_kso==1 | samp_parl_ds3==1)   	
*define variable for having being in the estimation sample in an earlier period
sort p_id electionperiod
gen est_prev=0
forvalues n=1(1)5{
	replace est_prev=1 if est_samp[_n-`n']==1 & p_id==p_id[_n-`n'] 
	}
*define treatment dummy
gen treat= kso_app==1|elec_parl==1 

	
drop partner_id
gen partner_id= partner_id_0
egen k_y=group (llkk electionperiod)
		


*define dummies for having children, or small children
gen child_dum =child_0_18_d_0==1
 replace child_0_18_d_0=0 if child_0_18_d_0==.
 replace child_0_6_d_0=0 if child_0_6_d_0==.

 *define dummies for sex
gen woman=Kon==2 if Kon!=. 
gen man=woman==0
gen all=1

*define various relevant income variables such as man income
*during current and preiovous income period, as
-well as share of house hold income
foreach var in wage_inc_real  {
	egen `var'_mean= rowmean(`var'_1 `var'_2 `var'_3)
	egen `var'_lag= rowmean(`var'_n1 `var'_n2 `var'_n3)
	egen `var'_p_mean= rowmean(`var'_p_1 `var'_p_2 `var'_p_3)
	egen `var'_p_lag= rowmean(`var'_p_n1 `var'_p_n2 `var'_p_n3)
	gen `var'_share=`var'_mean/(`var'_mean+`var'_p_mean)
	gen `var'_share_lag=`var'_lag/(`var'_lag+`var'_p_lag)
	gen `var'_share_ch=`var'_share-`var'_share_lag
	gen `var'_ch=`var'_mean-`var'_lag
	gen `var'_hsum=  `var'_mean+ `var'_p_mean
	gen `var'_hsum_lag=  `var'_lag+ `var'_p_lag

}
*define varaibles for relative changes in household income
gen wage_inc_real_relch= wage_inc_real_ch/ wage_inc_real_lag
gen wage_inc_real_hrelch= wage_inc_real_ch/ wage_inc_real_hsum_lag
*define age difference variable

gen age_diff=  age_0 -age_p_0
 replace age_diff  = age_n4-age_p_n4 if age_diff==.
drop _merge
*add data on gender composition of workplaces
joinby valar p_id using "\\micro.intra\Projekt\P0624$\P0624_Gem\Data Extraction and Files\Data files\org_panel.dta", unmatched(master) _merge(_merge)


gen num_men_workplace=(1-women_workplace)*num_workplace
gen num_women_workplace=(women_workplace)*num_workplace
 
 *define sample medians by gender for estimation sample
foreach var in   num_men_workplace num_women_workplace women_workplace ///
age_diff  wage_inc_real_share_ch wage_inc_real_share_lag{
	bysort woman: egen `var'_med = median (`var') if main==1  & age_0<62 
}

 *define sample medians by gender for those treated
foreach var of varlist wage_inc_real_relch   wage_inc_real_hrelch{
	bysort woman : egen `var'_trmed = median (`var') if main==1  & age_0<62 &  treat==1 
}
 *define sample medians by gender and election period for those treated

foreach var of varlist wage_inc_real_ch  wage_inc_real_p_lag  wage_inc_real_lag{
bysort electionperiod woman: egen `var'_med = median (`var') if main==1  & age_0<62
}

 *define sample medians by gender and election period for those treated and with spouses not of retirment age
foreach var of varlist wage_inc_real_hrelch  wage_inc_real_ch wage_inc_real_relch   {
	bysort woman: egen `var'_tmed = median (`var') if main==1 & treat==1  & age_0<62 & agep_p_0<62 
}

*dummy for have income change above medians
gen  wage_inc_real_lag_abmed=  wage_inc_real_lag> wage_inc_real_lag_med if  wage_inc_real_lag!=.
gen wage_inc_real_relch_abmed=  wage_inc_real_relch>wage_inc_real_relch_trmed if wage_inc_real_relch!=.

*define dummies for household tupes based on income compposition in previous election period
gen typel_1= main==1 & wage_inc_real_share_lag <=.4 if wage_inc_real_share_lag !=. & valar<2014 & agep_p_0<62 & age_0<62
gen typel_2=  main==1 & wage_inc_real_share_lag>.4 &  wage_inc_real_share_lag<=.6 if wage_inc_real_share_lag !=. & valar<2014 & agep_p_0<62 & age_0<62
gen typel_3=  main==1 & wage_inc_real_share_lag>.6 if wage_inc_real_share_lag !=. & valar<2014 & agep_p_0<62 & age_0<62


*define dummies for being in sample and having children or not
gen typec_1= main==1 & valar<2014 & age_0<62 & child_dum ==1 
gen typec_2= main==1 & valar<2014 & age_0<62 & child_dum ==0 

*define dummies for being in sample and being above or bleow sample median in age of marriage
gen typeam_1= main==1 & valar<2014 & age_0<62 & age_mar_0<30 & age_mar_0!=.
gen typeam_2= main==1 & valar<2014 & age_0<62 & age_mar_0>=30 & age_mar_0!=.
replace typeam_1=1 if main==1 & valar<2014 & age_0<62 & age_mar_n4<30 & age_mar_n4!=.
replace typeam_2= 1 if main==1 & valar<2014 & age_0<62 & age_mar_n4>=30 & age_mar_n4!=.

*Define estimation sample that excludes those with partners retiring during the elction period
gen main_np= main==1 & age_p_n4<58

*define dummies for being in estimation sample and bing in either of the three age categories
gen typeam_1= main==1 & valar<2014 & age_0<62 & age_mar_0<30 & age_mar_0!=.
gen typeage_1= main==1 & age_diff<-3 if  age_diff!=. & valar<2014 & age_1<64  
gen typeage_2=  main==1  & age_diff>=-3   & age_diff<=3 if  age_diff !=. & valar<2014 & age_1<64  
gen typeage_3=  main==1  & age_diff>3 if  age_diff !=. & valar<2014 & age_1<64  

 
*Define dummies for being in the estiamtion sample and in a workplace
*with a large or small share of same sex workes prior to the election
gen typetempt_1 = main == 1   & women_workplace > women_workplace_med if valar<2014 & woman== 1 & women_workplace !=. 
replace typetempt_1 =1 if  main == 1   & women_workplace < women_workplace_med & valar<2014 & woman== 0 & women_workplace !=.
replace typetempt_1 =0 if typetempt_1!=1 


gen typetempt_2 = main == 1   & women_workplace <= women_workplace_med if valar<2014 & woman== 1 & women_workplace !=.
replace typetempt_2 =1 if  main == 1   & women_workplace >= women_workplace_med & valar<2014 & woman== 0 & women_workplace !=. 
replace typetempt_2 =0 if typetempt_2!=1 

 
*Define dummies for being in the estiamtion sample and in a workplace
*with a large or small number of opposite sex workes prior to the election
gen typeatempt_1 = main == 1   & num_men_workplace< num_men_workplace_med if valar<2014 & woman== 1 & num_men_workplace !=. 
replace typeatempt_1 =1 if  main == 1   & num_women_workplace < num_women_workplace_med & valar<2014 & woman== 0 & num_women_workplace !=.
replace typeatempt_1 =0 if typeatempt_1!=1 

gen typeatempt_2 = main == 1   & num_men_workplace >= num_men_workplace_med if valar<2014 & woman== 1 & num_men_workplace!=.
replace typeatempt_2 =1 if  main == 1   & num_women_workplace>= num_women_workplace_med & valar<2014 & woman== 0 &  num_women_workplace !=. 
replace typeatempt_2 =0 if typeatempt_2!=1 


gen ppshare_rel_co_alt = ppshare_rel_co_0
forvalues n=1/7{
 replace ppshare_rel_co_alt  = ppshare_rel_co_n`n' if ppshare_rel_co_alt ==.
}
*Define dummies for being in the estiamtion sample and in a marrige with 
*more or less traiditonal division or parental leave
gen typepar_1= main==1 &  ((ppshare_rel_co_alt <=.1 & man==1)| (ppshare_rel_co_alt >=.9 & woman==1))  if ppshare_rel_co_alt!=. & valar<2014 & age_1<64  
 gen typepar_2= main==1 &  ((ppshare_rel_co_alt >.1 & man==1)| (ppshare_rel_co_alt <.9 & woman==1))  if ppshare_rel_co_alt!=. & valar<2014 & age_1<64 
		
*Save data set
save temp_prom, replace

		
		
		
		
		
		
		
		
		
		
		
		
